define(['HealthMoodGraphService', 'HealthMoodConstants'], function() {
    'use strict';

    describe("The Health-Mood Graph Service", function (){
        var service, healthMoodConstants, httpBackend;

        beforeEach(function() {
            module('angularTemplateApp');
            jasmine.getJSONFixtures().fixturesPath='base/test/mock';

            inject(function(HealthMoodGraphService, HealthMoodConstants, $httpBackend) {
                service = HealthMoodGraphService;
                healthMoodConstants = HealthMoodConstants;
                httpBackend = $httpBackend;
            });
        });

        describe("when instantiated", function() {
            it("service should be defined correctly", function() {
                expect(service.getGraphConfig).toBeDefined();
                expect(healthMoodConstants).toBeDefined();
            });
        });

        describe("methods", function() {
            it("should construct a correct Graph config for Blood Pressure & Pulse", function() {
                var section = 'bp-pulse',
                    filter = {startDate: '01/01/2015', endDate: '01/05/2015'},
                    points = (getJSONFixture('bpp-points.json')).observation,
                    metaData = healthMoodConstants[section].entry.vitalObservationsMeta,
                    sectionTitle = healthMoodConstants[section].name;
                
                var graphConfig = service.getGraphConfig(section, filter, points, metaData, sectionTitle);

                expect(graphConfig.xAxis.minRange).toEqual(24 * 3600e3);
                expect(graphConfig.xAxis.title.text).toEqual('Date/Time');
                expect(graphConfig.xAxis.type).toEqual('datetime');

                expect(graphConfig.yAxis.length).toEqual(2);
                expect(graphConfig.yAxis[0].min).toEqual(0);
                expect(graphConfig.yAxis[1].min).toEqual(0);

                expect(graphConfig.series.length).toEqual(2);
                expect(graphConfig.series[0].name).toEqual('Blood Pressure');
                expect(graphConfig.series[1].name).toEqual('Pulse');
                expect(graphConfig.series[0].data.length).toEqual(5);
                expect(graphConfig.series[1].data.length).toEqual(5);
            });

            it("should construct a correct Graph config for Weight", function() {
                var section = 'weight',
                    filter = {startDate: '01/01/2015', endDate: '01/05/2015'},
                    points = (getJSONFixture('weight-points.json')).observation,
                    metaData = healthMoodConstants[section].entry.vitalObservationsMeta,
                    sectionTitle = healthMoodConstants[section].name;

                var graphConfig = service.getGraphConfig(section, filter, points, metaData, sectionTitle);

                expect(graphConfig.xAxis.minRange).toEqual(24 * 3600e3);
                expect(graphConfig.xAxis.title.text).toEqual('Date/Time');
                expect(graphConfig.xAxis.type).toEqual('datetime');

                expect(graphConfig.yAxis.allowDecimals).toBeFalsy();
                expect(graphConfig.yAxis.min).toEqual(0);
                expect(graphConfig.yAxis.plotBands).toBeNull();

                expect(graphConfig.series.length).toEqual(1);
                expect(graphConfig.series[0].name).toEqual('Weight');
                expect(graphConfig.series[0].data.length).toEqual(5);
            });

            it("should construct a correct Graph config for Glucose", function() {
                var section = 'glucose',
                    filter = {startDate: '01/01/2015', endDate: '01/05/2015'},
                    points = (getJSONFixture('glucose-points.json')).observation,
                    metaData = healthMoodConstants[section].entry.vitalObservationsMeta,
                    sectionTitle = healthMoodConstants[section].name;

                var graphConfig = service.getGraphConfig(section, filter, points, metaData, sectionTitle);

                expect(graphConfig.xAxis.minRange).toEqual(24 * 3600e3);
                expect(graphConfig.xAxis.title.text).toEqual('Date/Time');
                expect(graphConfig.xAxis.type).toEqual('datetime');

                expect(graphConfig.yAxis.allowDecimals).toBeFalsy();
                expect(graphConfig.yAxis.min).toEqual(0);
                expect(graphConfig.yAxis.plotBands).toBeNull();

                expect(graphConfig.series.length).toEqual(4);
                expect(graphConfig.series[0].name).toEqual('connecting-line');
                expect(graphConfig.series[1].name).toEqual('Unknown');
                expect(graphConfig.series[2].name).toEqual('Fasting (8 hours)');
                expect(graphConfig.series[3].name).toEqual('After Meal');
                expect(graphConfig.series[0].data.length).toEqual(5);
            });

            it("should construct a correct Graph config for Cholesterol", function() {
                var section = 'cholesterol',
                    filter = {startDate: '01/01/2015', endDate: '01/05/2015'},
                    points = (getJSONFixture('cholesterol-points.json')).observation,
                    metaData = healthMoodConstants[section].entry.vitalObservationsMeta,
                    sectionTitle = healthMoodConstants[section].name;

                var graphConfig = service.getGraphConfig(section, filter, points, metaData, sectionTitle);

                expect(graphConfig.xAxis.minRange).toEqual(24 * 3600e3);
                expect(graphConfig.xAxis.title.text).toEqual('Date');
                expect(graphConfig.xAxis.type).toEqual('datetime');

                expect(graphConfig.yAxis.allowDecimals).toBeFalsy();
                expect(graphConfig.yAxis.min).toEqual(0);
                expect(graphConfig.yAxis.plotBands).toBeNull();

                expect(graphConfig.series.length).toEqual(4);
                expect(graphConfig.series[0].name).toEqual('Total');
                expect(graphConfig.series[1].name).toEqual('HDL');
                expect(graphConfig.series[2].name).toEqual('LDL');
                expect(graphConfig.series[3].name).toEqual('Triglycerides');
                expect(graphConfig.series[0].data.length).toEqual(5);
            });

            it("should construct a correct Graph config for Mood", function() {
                var section = 'mood',
                    filter = {startDate: '01/01/2015', endDate: '01/05/2015'},
                    points = (getJSONFixture('mood-points.json')).observation,
                    metaData = healthMoodConstants[section].entry.vitalObservationsMeta,
                    sectionTitle = healthMoodConstants[section].name;

                var graphConfig = service.getGraphConfig(section, filter, points, metaData, sectionTitle);

                expect(graphConfig.xAxis.minRange).toEqual(24 * 3600e3);
                expect(graphConfig.xAxis.title.text).toEqual('Date/Time');
                expect(graphConfig.xAxis.type).toEqual('datetime');

                expect(graphConfig.yAxis.allowDecimals).toBeFalsy();
                expect(graphConfig.yAxis.min).toEqual(0);
                expect(graphConfig.yAxis.plotBands.length).toEqual(5);

                expect(graphConfig.series.length).toEqual(1);
                expect(graphConfig.series[0].name).toEqual('Mood');
                expect(graphConfig.series[0].data.length).toEqual(5);
            });
        });
    });
});